(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7529,        310]*)
(*NotebookOutlinePosition[      8177,        333]*)
(*  CellTagsIndexPosition[      8133,        329]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(**EARTH\)\ ORBIT\ INSERTION\ \((EOI)\)\ \(CALCULATIONS**\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\@\(4 \( \[Pi]\^2\) 
        \((2\/0.987026072818613897 - 1\/1.458336481)\)\)\)], "Input"],

Cell[BoxData[
    \(7.2748762097870081`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(7.2748762097870081` - Eros'\ velocity\ at\ perihelion\ \((AU/yr)\)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(7.2748762097870081`*\((1.495978707*10^11)\)\)\/\(365.2564*24*3600
        \)\)], "Input"],

Cell[BoxData[
    \(34485.7315309185663`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(34485.7315309185663` - Eros'\ velocity\ at\ perihelion\ \((m/s)\)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\@\(4 \( \[Pi]\^2\) \((2\/0.987026072818613897 - 1\/1.00000011)\)\)\)], 
  "Input"],

Cell[BoxData[
    \(6.36523896683844725`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(6.36523896683844725` - 
      Earth' s\ velocity\ at\ Eros' perihelion\ \((AU/yr)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(6.36523896683844725`*\((1.495978707*10^11)\)\)\/\(365.2564*24*3600
        \)\)], "Input"],

Cell[BoxData[
    \(30173.6986046885435`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(30173.6986046885435`  Earth' s\ velocity\ at\ Eros' perihelion\ 
      \((m/s)\)\)], "Input"],

Cell[BoxData[
    \(30173.6986046885435`\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(34485.7315309185663 - 30173.6986046885435\)], "Input"],

Cell[BoxData[
    \(4312.0329262300228`16.4261\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(4312.0329262300228`16.4261 - 
      The\ relative\ velocity\ between\ Earth\ and\ Eros\ \((m/s)\)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(4312.0329262300228`16.4261 - 2265\)], "Input"],

Cell[BoxData[
    \(2047.0329262300228`16.1025\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(2047.0329262300228`16.1025\  - \ 
      The\ relative\ velocity\ after\ the\ Moon - Earth - 
      Moon\ gravity\ assist \((m/s)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(384402*0.9451\)], "Input"],

Cell[BoxData[
    \(363298.330200000041`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(363298.330200000041`\  - \ 
      The\ Moon' s\ perigee\ distance\ \((km)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((6.67260000000000097`*^-11)\)*\((5.9742000000000015`*^24)\)\)], 
  "Input"],

Cell[BoxData[
    \(3.98634469200000296`*^14\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(3.98634469200000296`*^14\  - \ 
      The\ mass\ of\ the\ Earth\ *\ the\ gravitational\ constant\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\@2*
      \@\(3.98634469200000296`*^14
            \/\(\((363298.330200000041` + 6378)\)*1000\)\)\)], "Input"],

Cell[BoxData[
    \(1468.55967914557306`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(1468.55967914557306`\  - \ 
      Earth' s\ escape\ velocity\ out\ around\ the\ Moon\ \((m/s)\)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2047.0329262300228`16.1025 - 1468.55967914557306`\)], "Input"],

Cell[BoxData[
    \(578.473247084449937`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(578.473247084449937` - 
      The\ \[CapitalDelta]V\ required\ to\ drop\ Eros'\ velocity\ below\ 
        Earth' s\ escape\ velocity\ \((m/s)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(578.473247084449937`/1000\)], "Input"],

Cell[BoxData[
    \(0.578473247084449937`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(0.578473247084449937` - \ 
      The\ \[CapitalDelta]V\ required\ to\ drop\ Eros'\ velocity\ below\ 
        Earth' s\ escape\ velocity\ \((km/s)\)\)], "Input"],

Cell[BoxData[
    \(4.19816629416444353`*^15\  - \ 
      Mass\ of\ Eros\ when\ it\ arrives\ at\ Earth\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[ExponentialE]^\((0.578473247084449937`\/38.183766184073562`)\)\)], 
  "Input"],

Cell[BoxData[
    \(1.01526505555368551`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(4.19816629416444353`*^15\/1.01526505555368551`\)], "Input"],

Cell[BoxData[
    \(4.13504460849874355`*^15\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(4.19816629416444353`*^15 - 4.13504460849874355`*^15\)], "Input"],

Cell[BoxData[
    \(6.31216856657005287`*^13\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(6.31216856657005287`*^13 - \ Exhaust\ mass\ needed\ for\ EOI\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2500*44924\)], "Input"],

Cell[BoxData[
    \(112310000\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(112310000\  - \ Rate\ of\ fire\ for\ all\ mass\ drivers\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve\ [6.31216856657005287`*^13\/112310000 - x \[Equal] 0, \ x]\)], 
  "Input"],

Cell[BoxData[
    \({{x \[Rule] 562030.858033127422`}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \({{x \[Rule] 562030.858033127422`}\  - \ 
        The\ number\ of\ seconds\ needed\ to\ slow\ Eros\ down\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(562030.858033127422`/60\)], "Input"],

Cell[BoxData[
    \(9367.18096721879156`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(9367.18096721879156` - \ 
      The\ number\ of\ minutes\ needed\ to\ slow\ Eros\ down\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(9367.18096721879156`/60\)], "Input"],

Cell[BoxData[
    \(156.119682786979874`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(156.119682786979874` - \ 
      The\ number\ of\ hours\ needed\ to\ slow\ Eros\ down\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(156.119682786979874`/24\)], "Input"],

Cell[BoxData[
    \(6.50498678279082742`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(6.50498678279082742` - \ 
      The\ number\ of\ days\ needed\ to\ slow\ Eros\ down\)], "Input"]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 640}, {0, 424}},
WindowSize->{596, 342},
WindowMargins->{{2, Automatic}, {Automatic, 5}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 93, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[1827, 54, 110, 2, 50, "Input"],
Cell[1940, 58, 53, 1, 29, "Output"]
}, Open  ]],
Cell[2008, 62, 102, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[2135, 68, 111, 2, 42, "Input"],
Cell[2249, 72, 54, 1, 29, "Output"]
}, Open  ]],
Cell[2318, 76, 101, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[2444, 82, 103, 2, 50, "Input"],
Cell[2550, 86, 54, 1, 29, "Output"]
}, Open  ]],
Cell[2619, 90, 116, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[2760, 96, 112, 2, 42, "Input"],
Cell[2875, 100, 54, 1, 29, "Output"]
}, Open  ]],
Cell[2944, 104, 113, 2, 30, "Input"],
Cell[3060, 108, 53, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[3138, 113, 74, 1, 30, "Input"],
Cell[3215, 116, 60, 1, 29, "Output"]
}, Open  ]],
Cell[3290, 120, 133, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[3448, 127, 66, 1, 30, "Input"],
Cell[3517, 130, 60, 1, 29, "Output"]
}, Open  ]],
Cell[3592, 134, 163, 3, 50, "Input"],

Cell[CellGroupData[{
Cell[3780, 141, 46, 1, 30, "Input"],
Cell[3829, 144, 54, 1, 29, "Output"]
}, Open  ]],
Cell[3898, 148, 108, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[4031, 154, 97, 2, 30, "Input"],
Cell[4131, 158, 58, 1, 29, "Output"]
}, Open  ]],
Cell[4204, 162, 129, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[4358, 168, 131, 3, 50, "Input"],
Cell[4492, 173, 54, 1, 29, "Output"]
}, Open  ]],
Cell[4561, 177, 131, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[4717, 184, 82, 1, 30, "Input"],
Cell[4802, 187, 54, 1, 29, "Output"]
}, Open  ]],
Cell[4871, 191, 176, 3, 50, "Input"],

Cell[CellGroupData[{
Cell[5072, 198, 58, 1, 30, "Input"],
Cell[5133, 201, 55, 1, 29, "Output"]
}, Open  ]],
Cell[5203, 205, 180, 3, 50, "Input"],
Cell[5386, 210, 115, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[5526, 216, 100, 2, 42, "Input"],
Cell[5629, 220, 54, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5720, 226, 79, 1, 42, "Input"],
Cell[5802, 229, 58, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5897, 235, 84, 1, 30, "Input"],
Cell[5984, 238, 58, 1, 29, "Output"]
}, Open  ]],
Cell[6057, 242, 93, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[6175, 247, 43, 1, 30, "Input"],
Cell[6221, 250, 43, 1, 29, "Output"]
}, Open  ]],
Cell[6279, 254, 88, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[6392, 259, 100, 2, 42, "Input"],
Cell[6495, 263, 68, 1, 29, "Output"]
}, Open  ]],
Cell[6578, 267, 136, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[6739, 273, 56, 1, 30, "Input"],
Cell[6798, 276, 54, 1, 29, "Output"]
}, Open  ]],
Cell[6867, 280, 119, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[7011, 286, 56, 1, 30, "Input"],
Cell[7070, 289, 54, 1, 29, "Output"]
}, Open  ]],
Cell[7139, 293, 117, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[7281, 299, 56, 1, 30, "Input"],
Cell[7340, 302, 54, 1, 29, "Output"]
}, Open  ]],
Cell[7409, 306, 116, 2, 30, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

